$workdir     = ".\Original export\"
$outputdir   = ".\"
$filter      = "*.pcx"
$imagemagick = "C:\Program Files\ImageMagick\magick.exe"
Get-ChildItem "$workdir" -Filter "$filter" | Foreach-Object {
    $oldfile = "$workdir"+$_.Name
    $newfile = "$outputdir"+$_.BaseName.Substring(0, 1).ToUpper() + $_.BaseName.Substring(1) + '.png' -replace '_', ' '
    Write-Output "> $oldfile"
    Write-Output "< $newfile"
    & "$imagemagick" convert "$oldfile" -transparent 'rgb(252, 252, 252)' -transparent 'rgb(224, 224, 224)' -transparent 'rgb(204, 204, 204)' -transparent 'rgb(196, 196, 196)' "$newfile" | Wait-Process
}
