class KentaurMissile_Trail: Actor
{
	default
	{
		Radius 1;
		Height 1;
		Scale  0.5;
		Speed  3;
		Gravity 0;
		RenderStyle "Add";
		Alpha 1;
		+NOBLOCKMAP
		+NOTELEPORT
		+DONTSPLASH
		+FORCEXYBILLBOARD
		+NOINTERACTION
		+NOCLIP
		+MISSILE
		+FLATSPRITE
	}
	states
	{
		Spawn:
			TNT1 A 2;
			EXPG CDEFG 1 BRIGHT;
			Stop;
	}
}

class KentaurMissile_AfterExplosionEffect: Actor
{
	float curscale;
	float rolldirection;
	float rollspeed;
	default
	{
		+ROLLSPRITE
		projectile;
		renderStyle "Add";
		scale 1.5;
	}
	states
	{
		spawn:
			FRPG A 1 BRIGHT NODELAY
			{
				curscale  = 1.5;
				rollspeed = random(10, 30) * 1.0;
				if (random(0, 1) == 0)
					rolldirection = 1.0;
				else
					rolldirection = -1.0;
			}
			FRPG ABCDEFGGHH 6 BRIGHT
			{
				float curroll = rollspeed * curscale * rolldirection;
				A_SetScale(curscale);
				A_SetRoll(curroll);
				curscale = curscale + 0.1;
			}
			stop;
	}
}

class KentaurMissile: Actor
{
	default
	{
		+SPAWNSOUNDSOURCE
		projectile;
		// Stats
		radius 4;
		speed 24;
		height 4;
		damage 60;
		damagetype "fire";
		// Appearance
		RenderStyle "Add";
		Scale 1.5;
		SeeSound    "CentaurLeaderAttack";
		DeathSound  "centaur/missilehit";
	}
	states
	{
	spawn:
		CNTM A 3 BRIGHT;
		CNTM A 1 BRIGHT
		{
			A_SpawnItemEx("KentaurMissile_Trail", 0, 0, 0, 0, 0, 0, 0, 128);
			self.vel.x += 0.4 * cos(self.angle);
			self.vel.y += 0.4 * sin(self.angle);
		}
		loop;
	death:
		CNTM B 4 BRIGHT
		{
			A_SpawnItemEx("CentaurMissile_ShockEffect");
			A_Quake(2, 8, 0, 144	);
		}
		CNTM C 3 BRIGHT A_SpawnItemEx("KentaurMissile_AfterExplosionEffect");
		CNTM D 4 BRIGHT;
		CNTM E 3 BRIGHT;
		CNTM F 2 BRIGHT;
		Stop;
	}
}

/* Variant - „Slaughtaur”? */
class Kentaur: Actor
{
	int stepcounter;  /* Walking states every second frame play step sound */
	int followplayer;

	int isfriendly(void)
	{
		CVar cv = CVar.FindCVar("kentaur_ally");
		return (cv && cv.GetInt() == 1);
	}

	action void DoMeleeAttack(void)
	{
		switch (random(1, 2))
		{
		case 1:
			A_CustomMeleeAttack(meleedamage*4, "centaur/hitflesh", "HAMMIS2", "decapitate");
			break;
		case 2:
			A_CustomMeleeAttack(meleedamage*4, "centaur/hitflesh", "HAMMIS2", "tear");
			break;
		}
	}

	/*
	 * Apply damage of the given type for each Thing within the given radius.
	 * By default, all monsters are alerted.
	 * Don't hurt friends!
	 */
	action int StampedeFunc(
		int dmg = 50,
		int rad = 10,
		name mod1 = "none", name mod2 = "none", int flags = XF_NOTMISSILE,
		bool alert = true)
	{
		int count = 0;
		if (!(flags & XF_EXPLICITDAMAGETYPE) && mod1 == "none" && mod2 == "none")
		{
			mod1 = damagetype;
			mod2 = damagetype;
		}
		if (alert)
			A_AlertMonsters();
		for (let it = BlockThingsIterator.Create(self, rad); it.Next();)
		{
			if (it.thing != self || (flags & XF_HURTSOURCE))
			{
				CVar cv = CVar.FindCVar("kentaur_ally");
				/* Skip player if friendly */
				if (it.thing.species == "marine" && (cv && cv.GetInt() == 1))
				{
					continue;
				}
				name mod = mod1;
				if (random(1, 2) == 1)
				{
					mod = mod2;
				}
				it.thing.DamageMobj(self, (flags & XF_NOTMISSILE) ? self : target, dmg, mod);
				count++;
			}
		}
		return count;
	}

	/* What says on the tin. */
	int sign(int x)
	{
		if (x > 0.0)
			return 1.0;
		else if (x < 0.0)
			return -1.0;
		return 0.0;
	}

	/*
	 * Because it's been taking a long time to debug, this function only
	 * approximates where the target will be and returns the angle at which
	 * the projectile should be thrown at.
	 * Correct geomtric caluclations have failed, no idea if it's because of
	 * fixed point arithmetic and that I'm using it incorrectly.
	 * This will do.
	 */
	int aproximateFireAngle(int sx, int sy, int tx, int ty, vector2 velocity)
	{
		/*int dx = tx - sx;
		int dy = ty - sy;
		int d  = sqrt(dx*dx + dy*dy);*/
		int len = sqrt(velocity.Length());
		if (len > 15.0)
			len = 15.0;
		vector2 v0;
		v0.x = sx - tx;
		v0.y = sy - ty;
		vector2 v1;
		v1.x = sx - (tx + velocity.x);
		v1.y = sy - (ty + velocity.y);
		int b0 = atan2(v0.y, v0.x);
		int b1 = atan2(v1.y, v1.x);
		int alpha = len * 8 * sign(b1 - b0);
		return alpha;
	}

	/* Parameter definitions */ 
	default
	{
		// Definition
		+DONTHARMSPECIES
		+NOINFIGHTSPECIES
		+NOFEAR
		+FLOORCLIP
		+SEEINVISIBLE
		+BUDDHA
		+TELESTOMP
		+SHIELDREFLECT
		+QUICKTORETALIATE
		-COUNTKILL
		monster;
		tag "Centaur Ally";
		obituary "$ALLYCENTAUR_OB";
		//+invulnerable - The Actor won't get hurt (won't go into pain state)
		// Stats
		health 630000; /* Just put a huge value here... */
		speed 16;
		maxStepHeight 24;
		maxDropOffHeight 24;
		maxTargetRange 5000;
		mass 120;
		painchance 200;
		// Appearance
		scale 1.3;
		height 72;
		// Damage - check mapinfo lump file for the damagetype definition.
		meleerange  86;
		meleedamage 60;
		damagetype "decapitate";
		// Sound
		seeSound    "CentaurSight";
		attackSound "centaur/hitmetal";
		painSound   "CentaurPain";
		deathSound  "CentaurDeath";
		activeSound "CentaurActive";
		howlSound   "PuppyBeat";
	}
	/* State definitions */
	states
	{
	spawn:
		CNTR A 1 NODELAY
		{
			CVar cv = CVar.FindCVar("kentaur_ally");
			followplayer = (cv && cv.GetInt() == 1);
			if (followplayer)
			{
				self.bFriendly = true;
			}
			else
			{
				self.bFriendly = false;
			}
		}
		/*
		CNTR ABCDABCD 6
		{
			A_Wander();
			A_Look();
			if (stepcounter++ % 2 == 0)
				A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
		}
		*/
		---- A 0 A_Jump(255, "see");
		---- A 0; //A_Log("#{{ @spawn (random angle) }}");
		CNTR B 16;
		CNTR B 30 A_SetAngle(random(-180.0, 180.0));
		loop;
	// Idling (with only player nearby)
	idle:
		CNTR B 16;
		CNTR B 16
		{
			if (random(1, 10) > 4)
			{
				SetState(FindState("idle"));
			}
			else
			{
				A_ClearTarget();
				A_LookEx(LOF_NOJUMP);
				if (target && !CheckClass("PlayerPawn", AAPTR_TARGET, true))
				{
					SetState(FindState("see"));
				}
			}
		}
		CNTR A 4 A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
		CNTR A 8
		{
			A_SetAngle(random(-180.0, 180.0));
		}
		CNTR B 30 A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
		---- A 0
		{
			A_ClearTarget();
			A_LookEx(LOF_NOJUMP);
		}
		goto see;
	see:
		CNTR A 0
		{
			A_FaceTarget();
			if (CheckClass("PlayerPawn", AAPTR_FRIENDPLAYER, true) || (target && CheckClass("PlayerPawn", AAPTR_TARGET, true)))
			{
				CVar cv = CVar.FindCVar("kentaur_ally");
				followplayer = 0;
				if (cv && cv.GetInt() == 1)
				{
					followplayer = 1;
				}
			}
			else if (target)
			{
				followplayer = 0;
			}
			if (followplayer)
			{
				self.bFriendly = true;
			}
			else
			{
				self.bFriendly = false;
			}
			if (random(1, 6) > 4)
			{
				SetState(FindState("seefast"));
			}
		}
		CNTR ABCD 4
		{
			if (followplayer)
			{
				int closedistance = meleerange * 3;
				int dist = GetDistance(false, AAPTR_PLAYER1);
				if (dist < closedistance && random(1, 10) == 1)
				{
					SetState(FindState("idle"));
				}
			}
			A_Chase();
			if (stepcounter++ % 2 == 0)
			{
				A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
			}
		}
		/* Check target's distance */
		---- A 0
		{
			int dist;
			if (followplayer)
				dist = GetDistance(false, AAPTR_PLAYER1);
			else
				dist = GetDistance(false, AAPTR_TARGET);
			int closedistance = meleerange * 3;
			int middistance = meleerange * 5;
			int fardistance = meleerange * 10;
			if (!followplayer)
			{
				/* Close */
				if (dist < closedistance && random(1, 10) > 5)
				{
					if (random(0, 1) == 0)
					{
						SetState(FindState("shieldup"));
					}
					else
					{
						A_Recoil(0.2 * mass);
					}
				}
				/* Middle  */
				else if(dist < middistance && random(1, 10) > 7)
				{
					SetState(FindState("sidestep"));
				}
			}
			/* Far  */
			if (dist > fardistance)
			{
				SetState(FindState("chasefast"));
			}
		}
		loop;
	chasefast:
		CNTR ABCDABCDABCD 4
		{
			int fardistance  = meleerange * 10;
			int defaultspeed = self.speed;
			self.speed *= 2.5;
			A_Chase();
			self.speed = defaultspeed;
			int dist;
			if (followplayer)
			{
				dist = GetDistance(false, AAPTR_PLAYER1);
			}
			else
			{
				dist = GetDistance(false, AAPTR_TARGET);
			}
			if (stepcounter++ % 2 == 0)
			{
				A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
			}
			if (dist < fardistance)
			{
				SetState(FindState("see"));
			}
		}
		loop;
	sidestep:
	seefast:
		CNTR ABCD 4
		{
			A_FastChase();
			A_FaceTarget();
			if (stepcounter++ % 2 == 0)
			{
				A_PlaySound("centaur/step", CHAN_AUTO, 0.2);
			}
		}
		goto see;
	/* Hurt. Raise the shield. */
	pain:
		CNTR G 0
		{
			if (!self.bFriendly)
			{
				A_Pain();
			}
			else
			{
				SetState(FindState("see"));
			}
		}
	shieldup:
		CNTR G 6
		{
			A_FaceTarget();
			A_SetReflectiveInvulnerable();
		}
		CNTR EE   6;
		CNTR EEEE 6
		{
			/* It is more likely to do a melee charge than missile attack. */
			A_FaceTarget();
			int dist = GetDistance(false, AAPTR_TARGET);
			int closedistance = meleerange * 3;
			if (dist < closedistance && random(0, 10) > 6)
			{
				A_UnSetReflectiveInvulnerable();
				if (random(0, 2) == 0)
					SetState(FindState("missileclose"));
				else
					SetState(FindState("meleeclose"));
			}
		}
		CNTR E 1 A_UnSetReflectiveInvulnerable;
		goto see;
	/* In case somebody gets close whilst the shild is up. */
	meleeclose:
		CNTR H 12
		{
			A_PlaySound("CentaurActive");
			if (target && CheckClass("PlayerPawn", AAPTR_TARGET, true) && isfriendly())
			{
				SetState(FindState("see"));
			}
		}
		---- A 0  { self.bSolid = false; }
		CNTR HI 4
		{
			A_FaceTarget();
			A_Recoil(-0.2 * mass);
			A_Quake(1, 4, 0, meleerange*3);
			StampedeFunc(80, meleerange/2.0, "stomp", "explosion", XF_NOTMISSILE|XF_NOSPLASH);
		}
		---- A 0  { self.bSolid = true; }
		CNTR J 10
		{
			A_FaceTarget();
			A_Quake(9, 8, 0, meleerange);
			DoMeleeAttack();
		}
		CNTR J 6 A_FaceTarget();
		CNTR I 6
		{
			if (random(1, 4) > 2)
				SetState(FindState("see"));
			else
				SetState(FindState("missilequickly"));
		}
		goto missilequickly;
	/* Melee attack. Push towards the target before attacking. */
	melee:
		CNTR H 5
		{
			if (target && CheckClass("PlayerPawn", AAPTR_TARGET, true) && isfriendly())
			{
				SetState(FindState("see"));
			}
			else
			{
				A_FaceTarget();
			}
		}
		CNTR I 4
		{
			A_FaceTarget();
			A_Recoil(-0.05 * mass);
		}
		CNTR J 8
		{
			A_FaceTarget();
			A_Recoil(-0.05 * mass);
			DoMeleeAttack();
		}
		goto see;
	missileclose:
		CNTR ABCD 4
		{
			int defaultspeed = self.speed;
			self.speed *= 2;
			A_FastChase();
			self.speed = defaultspeed;
			A_FaceTarget();
			if (random(1, 10) > 8)
				SetState(FindState("missileclose"));
		}
	missile:
		CNTR E 1 A_PlaySound("CentaurActive");
	missileagain:
		CNTR E 7;
	missilequickly:
		CNTR E 2
		{
			if (target && CheckClass("PlayerPawn", AAPTR_TARGET, true) && isfriendly())
				SetState(FindState("see"));
			else
			{
				A_FaceTarget();
				A_SetReflectiveInvulnerable();
			}
		}
		CNTR F 12 BRIGHT
		{
			A_FaceTarget();
			if (target)
			{
				vector2 velocity;
				velocity.x = target.vel.x;
				velocity.y = target.vel.y;
				int aproxalpha = aproximateFireAngle(self.x, self.y, target.x, target.y, velocity);
				switch(random(0, 6))
				{
					case 0:
						A_CustomMissile("KentaurMissile", 45, 0, 0, CMF_AIMOFFSET);
						break;
					case 1:
						A_CustomMissile("KentaurMissile", 45, 0, -15, CMF_AIMOFFSET);
						A_CustomMissile("KentaurMissile", 45, 0, +15, CMF_AIMOFFSET);
						break;
					case 2:
						A_CustomMissile("KentaurMissile", 45, 0, -15, CMF_AIMOFFSET);
						A_CustomMissile("KentaurMissile", 45, 0,   0, CMF_AIMOFFSET);
						A_CustomMissile("KentaurMissile", 45, 0, +15, CMF_AIMOFFSET);
						break;
					case 3:
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha-25, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha+25, CMF_AIMOFFSET);
						break;
					case 4:
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha, CMF_AIMOFFSET);
						break;
					case 5:
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha-30, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha+30, CMF_AIMOFFSET);
						break;
					case 6:
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha-15, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha-5, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha+5, CMF_AIMOFFSET);
							A_CustomMissile("KentaurMissile", 45, 0, aproxalpha+15, CMF_AIMOFFSET);
						break;
				}
			}
		}
		---- A 0
		{
			int defaultspeed = self.speed;
			self.speed = 0;
			A_UnSetReflectiveInvulnerable();
			A_Chase();
			self.speed = defaultspeed;
			if (CheckIfTargetInLOS() && random(1, 10) > 7)
				SetState(FindState("missileagain"));
		}
		goto see;
	// Death is not an option, but whatever.
	death:
		CNTR KLMNOPQRS 8;
		CNTR T -1 ACS_Execute(2, 0, 0, 0, 0);
		stop;
	}
}
