class HellKnightFriend : HellKnight
{
	private int medikit_stock;

	property medikitstock : medikit_stock;

	default
	{
		//$Category Friends
		//$Title Hell Knight
		//$Sprite HKFRA0
		+FRIENDLY
		-COUNTKILL
		+MISSILEMORE
		+MISSILEEVENMORE
		howlsound "knight/pain";
		HellKnightFriend.medikitstock 3;
	}
	
	override bool
	Used(Actor user)
	{
		A_Face(user);
		if (medikit_stock)
		{
			medikit_stock--;
			A_SpawnItem(((medikit_stock >= 1) ? "Medikit" : "Stimpack"), 24, 32);	
		}
		else
		{
			A_PlaySound(howlsound, CHAN_VOICE);
		}
		
		return true;
	}
	
	states
	{
	}
}

class HellKnightFriend_SoulSphere : HellKnightFriend
{
	override void
	Die(Actor source, Actor inflictor, int dmgflags, Name MeansOfDeath)
	{
		A_SpawnItemEx("SoulSphere", 0, 0, 38);
		super.Die(source, inflictor, dmgflags, meansofdeath);
	}
	
	default
	{
		//$Category Friends
		//$Title Hell Knight (SoulSphere)
		//$Sprite HKFRA0
	}
}

/* TODO: Rename and move to other script. Not actually 'dormant'. */
class HellKnightFriend_Dormant : HellKnightFriend
{
	default
	{
		//$Category Friends
		//$Title Hell Knight (broken)
		//$Sprite HKFRA0
		speed 0;
	}
	
	states
	{
	}
}

class Demon_Dormant : Demon
{
	default
	{
		speed 0;
		damage 0;
	}
	
	states
	{
		spawn:
			SARG A 0;
			goto super::spawn;
	}
}
