class BlueBall_Shock : Actor
{
	default
	{
		projectile;
		+NOGRAVITY
		+WINDTHRUST
		+DONTFALL
		+NOBLOCKMAP
		+NOLIFTDROP
		+NOTRIGGER
		
		scale 1.25;
	}
	states
	{
		spawn:
			SH1K A       4 BRIGHT NODELAY A_PlaySound("centaur/zap", CHAN_AUTO);
			SH1K ABCDEFG 2 BRIGHT;
		death:
			SMO2 G 0;
			stop;
	}
}

class BlueBall_Explosion : Actor
{
	float curscale;
	float rolldirection;
	float rollspeed;
	
	default
	{
		+ROLLSPRITE
		projectile;
		renderStyle "Add";
		scale 1.5;
	}
	
	states
	{
		spawn:
			FRPG A 1 BRIGHT NODELAY
			{
				curscale  = 1.5;
				rollspeed = random(10, 30) * 1.0;
				if (random(0, 1) == 0)
					rolldirection = 1.0;
				else
					rolldirection = -1.0;
			}
			FRPG ABCDEFGGHH 4 BRIGHT
			{
				float curroll = rollspeed * curscale * rolldirection;
				A_SetScale(curscale);
				A_SetRoll(curroll);
				curscale = curscale + 0.1;
			}
			stop;
	}
}

class BlueBall: Actor
{
	default
	{
		projectile;
		+ROCKETTRAIL
		+SPAWNSOUNDSOURCE
		
		radius 4;
		speed 28;
		height 4;
		damagetype "plasma";
		damagefunction (random(8, 15) * 8 + 50);
		
		renderstyle "Add";
		scale 1.5;
		seesound    "CentaurLeaderAttack";
		deathsound  "centaur/missile_hit";
	}
	
	states
	{
	spawn:
		CNTM A 3 BRIGHT;
		loop;
	death:
		CNTM B 4 BRIGHT
		{
			A_SpawnItemEx("BlueBall_Shock");
			A_Explode(144, 64, 0);
			A_Quake(3, 8, 0, 256);
		}
		CNTM C 3 BRIGHT A_SpawnItemEx("BlueBall_Explosion");
		CNTM D 4 BRIGHT;
		CNTM E 3 BRIGHT;
		CNTM F 2 BRIGHT;
		stop;
	}
}

/* Variant - „Slaughtaur”? */
class Kentaur: Actor
{
	//int stepcounter;  /* Walking states every second frame play step sound */
	Actor give_to;
	
	private int medikit_stock;
	private int backpack_stock;
	private int armour_stock;

	property medikitstock : medikit_stock;
	property backpackstock : backpack_stock;
	property ArmourStock : armour_stock;

	action void
	A_CentaurMaybeCharge(bool force_recoil = false)
	{
		A_FaceTarget();
		if (force_recoil || (target && distance2d(target) <= (meleerange - 2)))
		{
			A_Recoil(-18.0 / 2.0);
		}
	}
	
	action void
	A_CentaurMelee(void)
	{
		int damage = (random(2,15) * 5 + 20);
		
		if (damage > (12 * 5 + 20))
		{
			A_Quake(2, 17, 0, 196);
			damage = damage * 4;
			A_CustomMeleeAttack(damage, "centaur/hit2", "HAMMIS2", "saw");
		}
		else
		{
			A_CustomMeleeAttack(damage, "centaur/hit", "HAMMIS2", "head");
		}
	}
	
	/*
	 * Assuming we checked that at least one item is in stock.
	 */
	void
	GiveItem()
	{
		int choice = 0;
		string item;
		
		A_Face(give_to);
		do
		{
			choice = random(1, 3);
			
			if (choice == 1 && !medikit_stock
			 || choice == 2 && !armour_stock
			 || choice == 3 && !backpack_stock)
			{
				choice = 0;
			}
		} while (choice == 0);
		
		switch (choice)
		{
		case 1: item = "Medikit";    medikit_stock--;   break;
		case 2: item = "GreenArmor"; armour_stock--; break;
		case 3: item = "Backpack";   backpack_stock--;  break;
		}
		
		A_SpawnItem(item, 0, 48);
	}
	
	bool
	CheckStock(void)
	{
		return (medikit_stock || armour_stock || backpack_stock);
	}
	
	void A_CentaurJump(void)
	{
		// TODO: Check if on floor.
		vel.z += 6;
	}
	
	override bool
	CanTouchItem(Inventory item)
	{
		if (item is "BlueGem" || item is "SmallBlueGem")
		{
			ACS_NamedExecute("ccollect", 0, 0, 0, 0);
			return true;
		}
		else
		{
			return false;
		}
	}
	
	override bool
	Used(Actor user)
	{
		if (!InStateSequence(curstate, ResolveState("melee")))
		{
			give_to = user;
			SetStateLabel("give");
			return true;
		}
		else
		{
			return false;
		}
	}

	default
	{
		//$Category Friends
		//$Title Centaur
		//$Sprite CNTRZ0
		monster;
		+FRIENDLY
		+BUDDHA
		+TELESTOMP
		+PICKUP
		+QUICKTORETALIATE
		+SHIELDREFLECT
		+FLOORCLIP
		+MISSILEMORE
		+USESPECIAL
		-COUNTKILL
		
		Kentaur.MedikitStock 5;
		Kentaur.ArmourStock 1;
		Kentaur.BackpackStock 3;
		
		tag     "Centaur";
		species "Centaur";
		
		health 1500;
		
		speed 24;
		
		maxStepHeight 48;
		maxDropOffHeight 128;
		maxTargetRange 5000;
		
		mass 900;
		painchance 195;
		
		scale 1.3;
		height 78;
		radius 42;
		
		meleerange     88;
		MinMissileChance 105;
		
		seeSound    "centaurSight";
		//attacksound "centaur/attack";
		painSound   "centaurPain";
		deathSound  "centaurDeath";
		activeSound "centaurActive";
		howlsound   "centaur/sad";
		
		hitobituary "$OB_CENTAUR";
		obituary    "$OB_CENTAUR";
	}
	
	/* State definitions */
	states
	{
	spawn:
		CNTR AB 6 A_Look;
		loop;
	see:
		CNTR ABCD 4 A_Chase;
		loop;
	melee:
		CNTR HI 4 A_CentaurMaybeCharge();
		CNTR J  2 A_CentaurMaybeCharge(true);
		CNTR J  6 A_CentaurMelee();
		CNTR JI 6;
		goto see;
	missile:
		CNTR E 6 A_FaceTarget();
		CNTR F 0  BRIGHT A_PlaySound("centaur/shield");
		CNTR F 12 BRIGHT A_SpawnProjectile("BlueBall", 45, 0, 0, 0);
		CNTR F 0  BRIGHT A_JumpIf((target && (distance2d(target) < 225)), "melee");
		goto see;
	give:
		CNTR A 6 A_Face(give_to);
		CNTR A 4 A_JumpIf(!CheckStock(), "give_nostock");
		CNTR A 4 A_CentaurJump();
		CNTR B 9 GiveItem();
		CNTR B 1 A_StartSound("centaur/step", CHAN_BODY);
		goto see;
	give_nostock:
		CNTR A 16 A_PlaySound(howlsound, CHAN_VOICE);
		goto see;
	pain:
		CNTR G 4;
		CNTR E 6 A_SetReflectiveInvulnerable();
		CNTR EEEEE 6 A_CentaurDefend();
		CNTR E 11;
		CNTR E 1 A_UnsetReflectiveInvulnerable();
		goto see;
	death:
		CNTR KLMNOPQRS 8;
		CNTR S -1;
		stop;
	}
}
