class CombatKnifePuff: Actor
{
	Default
	{
		+NOBLOCKMAP
		+NOGRAVITY
		+NOEXTREMEDEATH
		+PUFFONACTORS

		RenderStyle "Translucent";
		Alpha 0.6;
		
		DamageType "knife";
		
		SeeSound    "weapon/combatknife/hit";
		AttackSound "weapon/combatknife/wall";
		ActiveSound "weapon/combatknife/miss";

		VSpeed 1;
	}
	
	States
	{
	Spawn:
		PUFF ABCD 4;
		stop;
	}
}

class CombatKnife: Weapon
{
	int defending;
	
	void
	SuccessfulGuard(void)
	{
		defending = 2;
	}

	Default
	{
		+WEAPON.MELEEWEAPON
		+NOEXTREMEDEATH
		+WEAPON.NOAUTOFIRE
		+WEAPON.NOALERT
		
		Weapon.SelectionOrder 3700;
		Weapon.Kickback 100;
		Weapon.SlotNumber 1;
		Weapon.BobRangeX 0;
	}
	
	States
	{
	spawn:
		KNFE A -1;
		loop;
	ready:
		KNFG A 1 A_WeaponReady;
		loop;
	deselect:
		KNFG A 1 A_Lower;
		loop;
	select: 
		KNFG A 1 A_Raise;
		loop;
	fire:
		KNFG B 2;
		KNFG C 6
		{
			A_CustomPunch(10, true, CPF_PULLIN , "CombatKnifePuff", 46);
			A_WeaponReady();
		}
		KNFG D 6;
		KNFG G 4;
		KNFG A 4 A_ReFire;
		goto ready;
	altfire:
		KNFG E 1 { invoker.defending = 1; }
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 1 A_JumpIf((invoker.defending == 2), "guard_success");
		---- A 0 { invoker.defending = 0; }
		goto ready;
	guard_success:
		KNFG I 2 { A_WeaponReady(); invoker.defending = 0; }
		goto ready;
	}
}
