//Vulgar
Class Vulgar: DoomImp
{
	override string GetObituary (Actor victim, Actor inflictor, name mod, bool playerattack)
	{
		string hitobituaries[] =
		{
			"A Vulgar had %o for lunch.",
			"A Vulgar mercilessly ate %o alive."
		};
		string obituaries[] =
		{
			"%o was poisoned by a vulgar.",
			"A Vulgar turned %o into a rotting pile of flesh."
		};

		if (mod == damagetype)
			return hitobituaries[Random(0, hitobituaries.Size() - 1)];
		else
			return obituaries[Random(0, obituaries.Size() - 1)];
	}

  default
  {
    obituary "%o was poisoned by a vulgar.";
    hitobituary "A Vulgar had %o for lunch.";
    health 70;
    radius 20;
    height 56;
    mass 120;
    speed 8;
    painchance 160;
    damage 4;
    damagetype "eat";
    meleethreshold 150;
    seesound "monster/vulsit";
    painsound "monster/vulpai";
    deathsound "monster/vuldth";
    activesound "monster/vulact";
    MONSTER;
    +FLOORCLIP
    +DONTHARMCLASS
  }

  states
  {
  spawn:
    VULG AB 10 A_Look();
    loop;
  see:
    VULG AABBCCDD 3
    {
			bool didmove = false;
			if (target && self.vec2to(target).length() < meleethreshold)
			{
				if (random(1, 10) > 8)
				{
					A_FaceTarget();
					A_Recoil(-14.0);
					SetState(FindState("meleequick"));
				}
				else
				{
					A_FastChase();
					didmove = true;
				}
			}
			if (!didmove)
				A_Chase();
    }
    loop;
	meleequick:
    VULG E 4 A_FaceTarget();
    VULG F 1 A_PlaySound("monster/vulswg");
    VULG F 4 A_FaceTarget();
    VULG G 3
    {
			A_CustomMeleeAttack(damage*random(1, 8), "monster/vulhit", "", damagetype, true);
			if (random(1, 10) > 6)
				SetState(FindState("missile"));
    }
    goto see;
  melee:
    VULG E 8 A_FaceTarget();
    VULG F 1 A_PlaySound("monster/vulswg");
    VULG F 7 A_FaceTarget();
    VULG G 6 A_CustomMeleeAttack(damage*random(1, 8), "monster/vulhit", "", damagetype, true);
    goto see;
  missile:
    VULG EF 8 A_FaceTarget();
    VULG G 6 A_SpawnProjectile("VulgarShot", 37, 0, 0, 0, 0);
    goto see;
  pain:
    VULG H 2;
    VULG H 2 A_Pain();
    goto see;
  death:
    VULG I 8;
    VULG J 8 A_Scream();
    VULG KL 6;
    VULG M 6 A_NoBlocking();
    VULG N -1;
    stop;
  xdeath:
    VULG O 5;
    VULG P 5 A_XScream();
    VULG Q 5;
    VULG R 5 A_NoBlocking();
    VULG STU 5;
    VULG V -1;
    stop;
  raise:
    VULG ML 8;
    VULG KJI 6;
    goto See;
  }
}

Class VulgarShot: Actor
{
	override void beginplay()
	{
		double addscale = random(0, 4) / 10.0;
		scale.x += addscale;
		scale.y += addscale;
	}
  Default
  {
    +THRUGHOST
    projectile;
    radius 8;
    height 16;
    speed 14;
    damage 4;
    damagetype "acid";
    poisondamage 40;
    poisondamagetype "acid";
    renderstyle "ADD";
    alpha 0.67;
    seesound   "monster/vulsh1";
    deathSound "monster/vulsh2";
    decal      "DoomImpScorch";
  }

  States
  {
  Spawn:
    FVUL AAABBB 1 Bright A_SpawnItemEx("BarbTrail", 0,0,0, 0,0,0, 0, SXF_CLIENTSIDE, 0);
    loop;
  Death:
    FVUL CDEF 4 Bright;
    stop;
  }
}

Class Barbtrail : Actor
{
  default
  {
		projectile;
    radius 0;
    height 1;
    renderstyle "ADD";
    alpha 0.75;
  }

  states
  {
  spawn:
    TNT1 A 1 Bright;
    SSFX ABCDEFG 2 Bright;
    Stop;
  }
}
