class Smallrat: Actor
{
	double closedistance;
	override void beginplay()
	{
			closedistance = 250.0;
			super.beginplay(); // In ZDoom, the super call is done by just super. instead of Super::
	}
	default
	{
		+NOINFIGHTING
		monster;
		health 15;
		radius 8;
		height 28;
		mass 5;
		speed 3;
		fastspeed 6;
		painchance 200;
		damagetype "bite";
		seesound    "smallrat/sight";
		attacksound "smallrat/attack";
		painsound   "smallrat/pain";
		deathsound  "smallrat/death";
		obituary "%o was nibbled by a rat.";
	}
	states
	{
	spawn:
		RATA A 10 A_Look;
		loop;
	see:
		RATA AAAABBBBCCC 1 A_Chase();
		RATA C 1
		{
			double dist = self.Vec2To(target).length();
			if (self.vec2to(target).length() < closedistance && random(1, 10) > 6)
			{
				A_Chase();
				A_FaceTarget();
				A_Recoil(-10.0);
			}
		}
		loop;
	melee:
    RATA A 8 A_FaceTarget;
    RATA B 3 A_CustomMeleeAttack(4, attackSound, "", damagetype, 0);
		goto see;
	pain:
		---- A 0 A_Pain();
		goto see;
	death:
		RATD A 0 A_Scream();
		RATD AAAABBBBCCCC 1;
		stop;
	}
}
