class Slimeworm: Actor
{
	int shotcount; // Number of missiles thrown per ranged attack

	/* Because of
	 * "wadsrc/static/zscript/actor.txt",
	 * Commit- https://github.com/coelckers/gzdoom/commit/fc125f7eafcac65805f3b62f9ae13eca774f0c47
	 * See line 433. Definition of "virtual String GetObituary" states that an
	 * attack yields a hitobituary if-
	 * `else if (mod == 'Melee' && HitObituary.Length() > 0)`.
	 * We aren't using "Melee" as damage type...
	 */
	override string GetObituary (Actor victim, Actor inflictor, name mod, bool playerattack)
	{
		string hitobituaries[] =
		{
			"A slimy worm digested %o.",
			"%o was eaten alive by a slime worm.",
			"A slime worm devoured %o."
		};
		string obituaries[] =
		{
			"%o was dissolved by a slime worm.",
			"A slime worm thawed %o into a bloody mess."
		};

		if (mod == damagetype)
			return hitobituaries[Random(0, hitobituaries.Size() - 1)];
		else
			return obituaries[Random(0, obituaries.Size() - 1)];
	}

	override void beginplay()
	{
			shotcount = 5;
			super.beginplay(); // In ZDoom, the super call is done by just super. instead of Super::
	}

	default
	{
		+FLOORCLIP
		+MISSILEMORE
		meleethreshold 150;
		maxtargetrange 1600;
		monster;
		health 200;
		painchance 90;
		speed 8;
		radius 30;
		height 56;
		mass 400;
		meleerange 52;
		damagetype  "devour";
		seesound    "slimeworm/sight";
		attacksound "slimeworm/melee";
		painsound   "slimeworm/pain";
		deathsound  "slimeworm/death";
		activesound "slimeworm/active";
		bloodcolor  "yellow";
	}
	states
  {
  spawn:
    WORM AB 10 A_Look;
    loop;
  see:
    WORM AABBCCDD 3
    {
			bool didmove = false;
			if (target && self.vec2to(target).length() < meleethreshold)
			{
				if (random(1, 10) > 8)
				{
					A_FaceTarget();
					A_Recoil(-20.0);
					SetState(FindState("meleequick"));
				}
				else
				{
					A_FastChase();
					didmove = true;
				}
			}
			if (!didmove)
				A_Chase();
    }
    loop;
  missile:
    WORM E 8 A_FaceTarget;
    WORM F 8
    {
			double distancetopitchratio = 120.0;
			double addpitch = 0.0;
			if (target)
				addpitch = self.vec2to(target).length() / maxtargetrange * distancetopitchratio;
			A_PlaySound("SlimeBall/Shoot");
			for (int i = 0; i < shotcount; i++)
				A_CustomMissile("Slimeworm_ball", 40, 0, random(-10,10), 2, random(10+addpitch, 15+addpitch));
		}
    WORM G 8;
    goto see;
  meleequick:
    WORM EF 3 A_FaceTarget;
    WORM G 3 A_CustomMeleeAttack(16, attacksound, "", damagetype, true);
    goto see;
  melee:
    WORM EF 8 A_FaceTarget;
    WORM G 8 A_CustomMeleeAttack(16, attacksound, "", damagetype, true);
    goto see;
  pain:
    WORM H 2;
    WORM H 2 A_Pain;
    goto see;
  death:
    WORM I 8;
    WORM J 8 A_Scream;
    WORM K 4;
    WORM L 4 A_NoBlocking;
    WORM M 4;
    WORM N -1;
    stop;
  raise:
    WORM NMLKJI 5;
    goto see;
  }
}

class Slimeworm_ball: DoomImpBall
{
	override void beginplay()
	{
		double addscale = random(0, 5) / 10.0;
		speed   += random(0, 10);
		scale.x += addscale;
		scale.y += addscale;
	}
	default
	{
		-NOGRAVITY
		radius 4;
		height 4;
		speed 14;
		damage 4;
		poisondamage 15;
		poisondamagetype "acid";
		damagetype "acid";
		seesound "";
		deathsound "slimeball/splat";
		scale 0.5;
		decal "PlasmaScorchLower";
	}
	states
	{
	Spawn:
		BOGY ABC 2 bright;
		loop;
	Death:
		BOGY D 0 bright A_NoGravity;
		BOGY DEF 4 bright;
		stop;
	}
}
