class Juggernaut_Rocket: Actor
{
	default
	{
		+MISSILE
		+NOGRAVITY
		+EXTREMEDEATH
		+BLOODSPLATTER
		+THRUSPECIES
		+MTHRUSPECIES
		+SPECTRAL
		radius 4;
		height 2;
		projectile;
		speed 24;
		damage 100;
		damagetype "explosion";
		scale 1.5;
		decal "scorch";
		projectile;
		seesound   "rocketlauncher/launch";
		deathsound "explosion/huge";
	}
	States
	{
	spawn:
		MISL A 0 NODELAY A_SpawnItemEx("ExplosionEffect_Hole");
	live:
		MISL A 4
		{
			double velovertime = 0.5;
			self.vel.x += velovertime * cos(self.angle);
			self.vel.y += velovertime * sin(self.angle);
		}
		loop;
	death:
		EXPL A 0
		{
				int range = 200;
				A_Quake(5, 6, 0, range*2);
				A_Explode(damage/2, range);
				A_SpawnItemEx("ExplosionEffect_Huge");
		}
		stop;
	}
}

class Juggernaut_Bullet: Actor
{
	default
	{
		+MISSILE
		+NOGRAVITY
		+EXTREMEDEATH
		+BLOODSPLATTER
		+THRUSPECIES
		+MTHRUSPECIES
		+SPECTRAL
		
		renderstyle "add";
		
		radius 6;
		height 4;
		projectile;
		speed 60;
		damagefunction 65;
		damagetype "tear";
		scale 0.8;
		decal "scorch";
		projectile;
		seesound   "juggernaut/bullet";
		//deathsound "explosion/huge";
	}
	
	override void
	BeginPlay(void)
	{
		switch (random(1, 2))
		{
		default:
		case 1: damagetype = "tear"; break;
		case 2: damagetype = "decapitate"; break;
		}
	}
	
	States
	{
	spawn:
		TRAC A 4
		{
			double velovertime = 2.5;
			self.vel.x += velovertime * cos(self.angle);
			self.vel.y += velovertime * sin(self.angle);
		}
		loop;
	death:
		TRAC A 0 A_Quake(1, 2, 0, 50);
		stop;
	}
}
