class ExplosionEffectBase: Actor
{
	default
	{
		+NOGRAVITY
		-SOLID
		-PUSHABLE
		-DONTFALL
		-COUNTKILL
		scale 1.25;
	}
}

class ExplosionEffect: ExplosionEffectBase
{
	states
	{
		spawn:
			NULL A 0 NODELAY
			{
				if (random(0, 1) == 1)
					A_SetScale(-1.0, 1.0);
			}
			EXP1 ABCDEFGHIJKLMN 3;
			stop;
	}
}

class ExplosionEffect_Huge: ExplosionEffect
{
	override void BeginPlay(void)
	{
		int addscale = random(5, 10) / 20.0;
		scale.x += addscale;
		scale.y += addscale;
	}
	default
	{
		scale 2.0;
	}
}

class ExplosionEffect_Green: ExplosionEffectBase
{
	default
	{
		Renderstyle "add";
	}
	states
	{
		spawn:
			NULL A 0 NODELAY
			{
				double addscale = random(0, 100) / 200.0;
				A_SetScale(scale.x+addscale, scale.y+addscale);
				A_PlaySound("Explosions/Big");
			}
			FRPG ABCDEFGH 3;
			stop;
	}
}

class ExplosionEffect_Hole: ExplosionEffectBase
{
	states
	{
		spawn:
			NULL A 0 NODELAY
			{
				if (random(0, 1) == 1)
					A_SetScale(-1.0, 1.0);
			}
			EXPL ABCDEFGH 3;
			stop;
	}
}
