class MarineArm: Actor
{
	default
	{
		Radius 8;
		Height 8;
		Scale 1.0;
		Speed 4;
		Mass 1;
		gravity 0.7;
		BounceFactor 0.6;
		wallbouncefactor 0.2;
		BounceCount 3;
		+DOOMBOUNCE;
		+MOVEWITHSECTOR;
		+CLIENTSIDEONLY;
		+NOBLOCKMAP;
		+NOTELEPORT;
		+MISSILE;
		+EXPLODEONWATER;
		+SKYEXPLODE;
		-DONTSPLASH;
		+THRUACTORS
	}
	states
	{
	spawn:
		XARM AEBCFDG 6;
		loop;
	death:
		XDT5 I 16;
		wait;
	}
}

class MarineLeg: MarineArm
{
	states
	{
	spawn:
	death:
		XDMG A -1;
		stop;
	}
}

class MarineTop: MarineArm
{
	default
	{
		Speed 5;
	}
	
	states
	{
	spawn:
	death:
		XDMG E -1; // XPL2 F
		stop;
	}
}

class MarineTop_NoHead: MarineArm
{
	states
	{
	spawn:
	death:
		HPLA B -1;
		stop;
	}
}

class MarineBottom: MarineArm
{
	private int side;
	private int dtype;
	
	default
	{
		Speed 4;
	}
	
	override void
	BeginPlay(void)
	{
		side = 1;
		
		if (random(1, 2) == 1)
		{
			side = -1;
			scale.x = -scale.x;
		}
		
		dtype = random(1, 2);
	}
	
	states
	{
	spawn:
		XPL2 AB  8 { if (dtype == 1) { SetStateLabel("death2"); } }
		XPL2 CDE 8;
		XPL2 F 1;
		goto spawn+5;
	death2:
		XPL2 B 12;
		XPL2 B -1 A_SpawnItemEx("Blood_GrowingPool", random(2, 6), -22*side);
		stop;
	death:
		---- A 0 { if (dtype == 1) { SetStateLabel("death2"); } }
		XPL2 F 12;
		XPL2 F -1 A_SpawnItemEx("Blood_GrowingPool", random(2, 6), -22*side);
		stop;
	}
}

class MarineTeeth: PlayerChunk
{
	default
	{
		+MISSILE;
		+NOBLOCKMAP
		+DROPOFF
		+SKYEXPLODE
		+NOBLOCKMONST
		+NOSKIN
		+BOUNCEONWALLS
		+BOUNCEONFLOORS
		+BOUNCEONACTORS
		+PUSHABLE
		-DONTTHRUST
		-FRIENDLY
		radius 4;
		height 4;
  }
	states
	{
	spawn:
		BRIB ABCD 4;
		loop;
	death:
		BRIB A -1;
		stop;
	}
}

class MarineHead: PlayerChunk
{
	bool upside_down;

	default
	{
		+MISSILE;
		+NOBLOCKMAP
		+DROPOFF
		+CANNOTPUSH
		+SKYEXPLODE
		+NOBLOCKMONST
		+NOSKIN
		+BOUNCEONWALLS
		+BOUNCEONFLOORS
		+BOUNCEONACTORS
		+USEBOUNCESTATE
		+PUSHABLE
		+THRUACTORS
		-DONTTHRUST
		-FRIENDLY;
		bouncetype "doom";
		bouncecount 2;
		radius 4;
		height 16;
		DeathHeight 16;
		Speed 18;
		Gravity 0.4;
	}
	
	override void
	BeginPlay(void)
	{
		upside_down = random(0, 1);
	}
	
	states
	{
	spawn:
		MHEA ABCD 5;
		loop;
	bounce:
		---- A 0 ACS_NamedExecute("RollCamera");
		goto spawn;
	death:
		---- A 0 A_JumpIf(upside_down, 2);
		MHEA A -1 ACS_NamedExecute("RollCamera");
		stop;
		MHEA C -1 ACS_NamedExecute("RollCamera");
		stop;
	}
}
