class Blood_Trail: Actor
{
	default
	{
		scale 0.25;
		mass 1;
		renderstyle "translucent";
		alpha 0.8;
		//Decal BrutalBloodSplat
		+NOTELEPORT
		+NOBLOCKMAP
		+FORCEXYBILLBOARD
		+CLIENTSIDEONLY
		+MISSILE
		+THRUACTORS
		+BOUNCEONWALLS
		+DONTSPLASH
		Gravity 0.4;
		Speed 2;
	}
	
	states
	{
	spawn:
		BLHT BCDEFG 1;
		BLHT HHHHHHHHH 1 A_FadeOut(0.02);
		stop;
	death:
		TNT1 A 0;
		stop;
	}
}

class Blood_New: Blood replaces Blood
{
	default
	{
		+FORCEXYBILLBOARD
		+THRUACTORS
		+CLIENTSIDEONLY
		
		renderstyle "translucent";
		scale 0.8;
		alpha 0.7;
		mass 999999;
	}
	
	states
	{
	spawn:
		BSPR A       2 A_CustomMissile ("Blood_Trail", 7, 0, random (0, 360), 2, random (30, 60));
		BSPR ABCDEFG 1;
		BSPR HHHHHHH 1 A_FadeOut(0.1);
		stop;
	}
}

class Blood_Small: Blood_New
{
	default
	{
		scale 0.4;
	}
}

class Blood_Ground: Actor
{
	override void 
	BeginPlay(void)
	{
		super.BeginPlay();
		
		float r = float(random(-35, 35))/100.0;
		scale.x += r;
		scale.y += r;
	}

	default
	{
		+FORCEXYBILLBOARD 
		+NOTELEPORT
		+CLIENTSIDEONLY
		+MOVEWITHSECTOR
		+DONTSPLASH
		+THRUACTORS
		-SOLID
		scale 0.9;
	}
	
	states
	{
	spawn:
		XDT1 FGHIJK 6;
		XDT1 L -1;
		stop;
	}
}

class Blood_Ground_Small: Blood_Ground
{
	default
	{
		xscale 0.25;
		yscale 0.55;
	}
}
/* Unused */
class Blood_GroundMess1: Actor
{
	override void 
	BeginPlay(void)
	{
		super.BeginPlay();
		
		float r = float(random(-35, 35))/100.0;
		scale.x += r;
		scale.y += r;
	}

	default
	{
		+FORCEXYBILLBOARD 
		+NOTELEPORT
		+CLIENTSIDEONLY
		+MOVEWITHSECTOR
		+DONTSPLASH
		+THRUACTORS
		-SOLID
		scale 0.5;
	}
	
	states
	{
	spawn:
		CRS1 B -1;
		stop;
	}
}

class Blood_GrowingPool: Actor
{
	float target_scale;
	
	property TargetScale: target_scale;
	
	default
	{
		Blood_GrowingPool.TargetScale 1.2;
	}
	
	override void
	Tick(void)
	{
		super.Tick();
		
		if (scale.x < target_scale) { scale.x += 0.01;              }
		else                        { scale.x  = target_scale+0.01; }
		if (scale.y < target_scale) { scale.y += 0.01;              }
		else                        { scale.y  = target_scale+0.01; }
		
		if (scale.x >= target_scale && scale.y >= target_scale)
		{
			SetStateLabel("death");
		}
	}

	default
	{
		+NOTELEPORT
		+CLIENTSIDEONLY
		+FORCEXYBILLBOARD
		+MOVEWITHSECTOR
		+FLOORCLIP
		+DONTSPLASH
		-SOLID
		+THRUACTORS
		+NOTELEPORT
		+MISSILE
		
		radius 1;
		height 1;
		mass 1;
		Alpha 0.99;
		Scale 0.3;
		Health 600;
		RenderStyle "Normal";
		//Decal BrutalBloodSplat
	}
	
	states
	{
	spawn:
		TNT5 A 0 NODELAY A_QueueCorpse();
		TNT5 A 1;
		goto spawn+1;
	death:
		TNT5 A -1;
		stop;
	}
}

class Blood_Guts: Actor
{
	default
	{
		+BOUNCEONWALLS
		+BOUNCEONCEILINGS
		+NOBLOCKMAP
		+MISSILE
		+NOTELEPORT
		+MOVEWITHSECTOR
		+CLIENTSIDEONLY
		+FORCEXYBILLBOARD
		-EXPLODEONWATER
		
		Radius 8;
		Height 12;
		Speed 6;
		Mass 1;
		BounceFactor 0.4;
		Renderstyle "translucent";
		Alpha 0.9;
		Scale 0.6;
		Gravity 0.4;
		//Decal BrutalBloodSplat;
    }
	
	override void 
	BeginPlay(void)
	{
		super.BeginPlay();
		
		switch (random(0, 3))
		{
		default:
		case 0: scale.x = scale.x*0.9;  scale.y = scale.y*0.8; break;
		case 1: scale.x = scale.x*-1.0; scale.y = scale.y*1.0; break;
		case 2: scale.x = scale.x*1.2;  scale.y = scale.y*1.0; break;
		case 3: scale.x = scale.x*-0.6; scale.y = scale.y*1.0; break;
		}
	}
	
	States
    {
    spawn:
		GUTS ABCDEFGH 2;
		loop;
    death:
        GUTS HIJ 3;
		---- A 0
		{
			A_QueueCorpse();
			A_Jump(256, random(0, 1));
		}
        GUTS K -1;
		stop;
        GUTS L -1;
		stop;
    }
}

class Blood_Gib: Actor
{
	string onground_item;

	override void 
	BeginPlay(void)
	{
		super.BeginPlay();
		
		if (random(1, 2) == 1)
		{
			scale.x = -scale.x;
		}
		
		float r = float(random(-25, 25))/100.0;
		scale.x += r;
		scale.y += r*0.95;
		
		onground_item = "Blood_Ground";
	}
	
	default
	{
		+NOBLOCKMAP
		+MISSILE
		+NOTELEPORT
		+MOVEWITHSECTOR
		+CLIENTSIDEONLY
		-DONTSPLASH
		+THRUGHOST
		+THRUACTORS
		+FLOORCLIP
		
		Radius 1;
		Height 1;
		Speed 12;
		Scale 1.0;
		Mass 1;
	}
	
	states
	{
	spawn:
		XDB5 ABCDEFGH 4;
		loop;
	death:
		XDB5 O 0
		{
			A_SpawnItemEx(onground_item, random(-6, 6), random(-4, 4));
			if (random(1, 8) == 1)
			{
				Actor pool_a;
				Blood_GrowingPool pool;
				bool success;
				
				[success, pool_a] = A_SpawnItemEx("Blood_GrowingPool", random(-6, 6), random(-4, 4));
				
				if (success && Blood_GrowingPool(pool_a))
				{
					pool = Blood_GrowingPool(pool_a);
					pool.target_scale = abs(radius*scale.x) + float(random(100, 500))/1000.0;
				}
			}
			
			if (random(1, 2) == 1)
			{
				SetStateLabel("death2");
			}
		}
		XDB5 O -1;
		stop;
	death2:
		CRS1 B -1 A_Log("A");
		stop;
	}
}

class Blood_Gib_Small: Blood_Gib
{
	override void 
	BeginPlay(void)
	{
		super.BeginPlay();
		
		scale.x *= 0.275;
		scale.y *= 0.275;
		
		onground_item = "Blood_Ground_Small";
	}
}

class Blood_Heart: Blood_Gib_Small
{
}

class Blood_MarineHead: Actor
{
	default
	{
		+MISSILE;
		+NOBLOCKMAP
		+DROPOFF
		+CANNOTPUSH
		+SKYEXPLODE
		+NOBLOCKMONST
		+NOSKIN
		+BOUNCEONWALLS
		+BOUNCEONFLOORS
		+BOUNCEONACTORS
		+PUSHABLE
		-DONTTHRUST
		-FRIENDLY;
		bouncetype "doom";
		bouncecount 2;
		radius 4;
		height 4;
		speed 8;
		gravity 0.2;
	}
	states
	{
	spawn:
	MHEA ABCD 5 NODELAY;
	loop;
	death:
		---- A 0
		{
			if (random(0, 1) == 1)
				setstatelabel("death_flipped");
		}
	death_normal:
		MHEA A -1;
		stop;
	death_flipped:
		MHEA C -1;
		stop;
	}
}
